/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:3*/
layout(location = 0) out vec3 bloomData;

#include "/lib/head.glsl"

//bloom downsampling method based on chocapic13's shaders
//merge and upsample blurs

uniform sampler2D colortex3;
uniform sampler2D colortex4;

uniform vec2 bloomResolution;
uniform vec2 pixelSize;
uniform vec2 viewSize;

in vec2 coord;

flat in float exposure;

#include "/lib/util/bicubic.glsl"

void main() {
	//if (clamp(coord, -0.003, 1.003) != coord) discard;
    vec2 tcoord     = (gl_FragCoord.xy*2.0+0.5)*pixelSize;
    vec2 rscale     = bloomResolution/max(viewSize, bloomResolution);
	vec3 blur       = vec3(0.0);

	vec2 c 	= coord*max(viewSize, bloomResolution) * rcp(bloomResolution * 0.5);

	if (clamp(c, -pixelSize, 1.0 + pixelSize) == c) {
		blur 	   += textureBicubic(colortex3, (tcoord+vec2(0.0, 0.5))/2.0).rgb / 4.0;    //1:4

        blur       += textureBicubic(colortex3, tcoord/4.0).rgb / 4.0;    //1:8

        blur       += textureBicubic(colortex3, tcoord/8.0+vec2(0.25*rscale.x+2.0*pixelSize.x, 0.0)).rgb / 4.0;   //1:16

        blur       += textureBicubic(colortex3, tcoord/16.0+vec2(0.375*rscale.x+4.0*pixelSize.x, 0.0)).rgb / 4.0;   //1:32

        blur       += textureBicubic(colortex3, tcoord/32.0+vec2(0.4375*rscale.x+6.0*pixelSize.x, 0.0)).rgb / 4.0;   //1:64

        blur       += textureBicubic(colortex3, tcoord/64.0+vec2(0.46875*rscale.x+8.0*pixelSize.x, 0.0)).rgb / 4.0;   //1:128

        blur       += textureBicubic(colortex3, tcoord/128.0+vec2(0.484375*rscale.x+10.0*pixelSize.x, 0.0)).rgb / 4.0;   //1:256

		blur       *= 1.0 / 7.0;

		//blur 		= texture(colortex3, gl_FragCoord.xy*pixelSize).rgb;
	}

    bloomData   = clamp16F(blur);

	//breaks with everything but 1440p
    /*
    vec2 rBloomRes = bloomResolution * pixelSize;
    float rTileScale    = bloomResolution.x * pixelSize.x;
    ivec2 blurCoord     = ivec2(floor(coord * rTileScale * rcp(128.0) * viewSize));
	blur 	= texelFetch(colortex3, blurCoord + ivec2(floor((vec2(0.484375*rscale.x+(10.0)*pixelSize.x, 0.0)) * viewSize)), 0).rgb;
	*/

	#ifdef newExposure
	//gl_FragData[1] 	= clampDrawbuffer(vec4(stex(colortex4).rgb, exposure));
	#else
	//gl_FragData[1] 	= stex(colortex4);
	#endif
}